<?php
include '../conexao.php';
$json = file_get_contents('php://input');
$data = json_decode($json, true);

$telefone = $data['from'] ?? '';
$mensagem = $data['body'] ?? '';
$numero_whatsapp = $data['instance'] ?? '';

if ($telefone && $mensagem) {
    $stmt = $pdo->prepare("SELECT id FROM clientes WHERE telefone = ?");
    $stmt->execute([$telefone]);
    $cliente = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($cliente) {
        $cliente_id = $cliente['id'];
    } else {
        $stmt = $pdo->prepare("INSERT INTO clientes (nome, telefone) VALUES (?, ?)");
        $stmt->execute([$telefone, $telefone]);
        $cliente_id = $pdo->lastInsertId();
    }

    $stmt = $pdo->prepare("INSERT INTO conversas (cliente_id, numero_whatsapp) VALUES (?, ?)");
    $stmt->execute([$cliente_id, $numero_whatsapp]);
    $conversa_id = $pdo->lastInsertId();

    $stmt = $pdo->prepare("INSERT INTO mensagens (conversa_id, mensagem, tipo, origem) VALUES (?, ?, 'recebida', 'cliente')");
    $stmt->execute([$conversa_id, $mensagem]);
}
http_response_code(200);
?>